#
# Parsovanje Sezam PAD-ova i konverzija poruka u .EML
#
# Copyright (C) 2023 Dejan Ristanovic
#  
# posao zapocet 11/04/2023
# v1.0 17/04/2023
# v1.2 22/04/2023
# v1.3 14/05/2023
#
import zipfile
import os
import sys
from os import listdir
from os.path import isfile, join
import shutil
import datetime

global logfile
global curpad
global curline

# e-mail adresa korisnika na SezamuPro
p_myadr="dejanr@sezam.com"
# e-mail adresa sistema SezamPro
p_system="@sezampro.rs"
# path ka folderu u kome se nalaze PADxxxxx.ZIP datoteke koje treba obraditi
p_pads="d:/spp/pads/"
# path ka folderu u koji treba stavljati rezultujuce EML fajlove
p_target="d:/spp/eml/"
# path ka temporary folderu u koji ce program raspakivati PAD-ove.
# ako u tom folderu ima necega, bice obrisano
p_temp="d:/spp/tmp/"
# ime fajla u koji ce biti upisivan dnevnik rada
p_log="d:/spp/log.txt"
#
# raspored Racunari
p_yuset=[166, 169, 170, 171, 172, 174, 175, 176, 177, 178, 350, 379, 731]
# tri znaka na kraju, 350, 379, 731, su dodatna transformacija jer encoding vec pri
# ucitavnju fajla translira neke od kodova iz (nestandardnog) Racunari rasporeda

def adresasistema(ulaz):
    if ulaz.find('@')<0:
       return ulaz+p_system
    else:
       return ulaz 

def yutransf(ulaz):
    targset="čćđšžČĆĐŠŽđĆŽ"
    ulaz_l=list(ulaz)
    for i in range(0, len(ulaz)):
        znak=ord(ulaz_l[i])
        for j in range(0,len(p_yuset)):
            if znak==p_yuset[j]:
               ulaz_l[i]=targset[j]
    rez="".join(ulaz_l)
    return(rez)

def filecopy(izvor, odrediste):
    shutil.copy(izvor, odrediste)

def vodecenule(ulaz, znakova):
    ll=len(ulaz)
    tmp=""
    for i in range(1, znakova+1-ll):
        tmp=tmp+"0"
    return tmp+ulaz

def gentime(yy,mn,dd,hh,mm,ss):
    dt = datetime.datetime(year=yy, month=mn, day=dd, hour=hh, minute=mm, second=ss)
    return dt

def extrdate (mmdat):
    dt=datetime.datetime(int(mmdat[6:10]), int(mmdat[3:5]), int(mmdat[0:2]), int(mmdat[11:13]), int(mmdat[14:16]), 0)
    dts=dt.strftime('%a, %d %b %Y %H:%M:%S %z')
    return dts

def mimemodul(input_file, zip_file, output_file, msgfrom, msgto, msgsubj, msgtime):
    # mimemodul je napravio ChatGPT, svaka mu cast
    import email.utils
    from email.mime.text import MIMEText
    from email.mime.multipart import MIMEMultipart
    from email.mime.application import MIMEApplication
#   with open(input_file, 'r', encoding='utf-8') as f:
#        text = f.read()
    text=input_file
    message = MIMEMultipart()
    message['From'] = email.utils.formataddr((msgfrom, msgfrom))
    message['To'] = email.utils.formataddr((msgto, msgto))
    message['Subject'] = yutransf(msgsubj)
    message['Date'] = msgtime
    message.attach(MIMEText(text))
    if zip_file>"":
       with open(zip_file, 'rb') as f:
           attachment = MIMEApplication(f.read(), _subtype='zip')
           attachment.add_header('Content-Disposition', 'attachment', filename=os.path.basename(zip_file))
           message.attach(attachment)
    with open(output_file, 'wb') as f:
        f.write(message.as_bytes())

def log(red, kord=True):
    if kord==True:
       logfile.write(curpad+"-Line: "+str(curline)+" "+red+"\n")
    else:
       logfile.write(red+"\n")
    print(red)

def fexists(ulaz):
    return os.path.isfile(ulaz)

def parsetp(mypath, ime):
   file1 = open(mypath+"/"+ime, 'r', errors="ignore")
   mbody=False
   mmod=""
   mmza=""
   curline=0
   grupa=False
   trebaparse=False
   celaporuka=""
   ignore=False
   preskociprazan=False
   while True:
      line = file1.readline()
      if not line: break
      line=line[:-1]
      curline+=1
      if mbody:
          if line[0:49]=="-------------------------------------------------" and line[-3:]==" --":
             mbody=False
             if not ignore:
                celaporuka=celaporuka+"\n"
                if trebaparse:
                    if celaporuka[0:10]=="Received: " and mmeml=="":
                       tf = open(p_target+idpor+"-"+curpad[0:8]+".eml", "w")
                       n = tf.write(celaporuka)
                       tf.close()
                    elif mmeml=="":
                        mimemodul(celaporuka, "", p_target+idpor+"-"+curpad[0:8]+".eml", mmod, mmza, mmtema, mmdat)
                    else:
                        mimemodul(celaporuka, p_temp+mmeml, p_target+idpor+"-"+curpad[0:8]+".eml", mmod, mmza, mmtema, mmdat)
          elif trebaparse==True:
## iz nekog razloga (bug?) kada linija ima 78 ili 79 slova, Sezam doda posle nje prazan red, koji narocito smeta u zaglavljima poruka
             if len(line)==0 and preskociprazan:
                preskociprazan=False
             else:
                if len(line)==78 or len(line)==79:
                   preskociprazan=True
                else: preskociprazan=False
                celaporuka=celaporuka+yutransf(line)+"\n"
      elif line=="================================":
          # konferencijska poruka, ignorisemo
          mbody=True
          ignore=True
      elif line=="==============================" or line=="===============================":
         nhl=0
         line = file1.readline()
         if not line: break
         line=line[:-1]
         curline+=1
         redovi=[""]
         while line!="---------------------------------------------------------------------":
            nhl+=1
            redovi.append(line)
            line = file1.readline()
            if not line: break
            line=line[:-1]
            curline+=1
            if nhl>6:
               log("Previse redova u zaglavlju")
               continue
         mbody=True
         red=redovi[1]
         if red[0:9]=="Poruka od" or red[0:6]=="Grupa ":
            if red[0:6]=="Grupa ":
               grupa=True
               zarez=red.find(',')
               if zarez<0:
                   log("Los heder #3")
                   continue
               mmza=red[6:zarez]
               gprefiks="G"
               if mmza=="forum" or mmza=="forum.2":
                   gprefiks="F"
               elif mmza=="klub" or mmza=="subrina":
                   gprefiks="K"
               elif mmza=="uprava":
                   gprefiks="U"
               mmza=mmza+p_system
               mmod=red[zarez+5:]
               zarez=mmod.find(",")
               if zarez<0:
                   mmeml=""
                   mmod=mmod+p_system
               else:
                   mmeml=mmod[zarez+3:]
                   mmod=mmod[0:zarez]+p_system
                   blanko=mmeml.find(" ")
                   if blanko>0: mmeml=mmeml[0:blanko]
            else:
                grupa=False
                mmza=p_myadr
                zarez=red.find(',')
                if zarez==-1:
                   mmod=adresasistema(red[10:])
                   mmeml=""
                else:
                   mmod=adresasistema(red[10:zarez])
                   mmeml=red[zarez+3:]
                   blanko=mmeml.find(" ")
                   if blanko>0: mmeml=mmeml[0:blanko]
         elif red[0:2]=="Va" and red[3:14]=="a poruka za":
            mmod=p_myadr
            zarez=red.find(',')
            if zarez==-1:
               mmza=adresasistema(red[15:])
               mmeml=""
            else:
               mmza=adresasistema(red[15:zarez])
               mmeml=red[zarez+3:]
               blanko=mmeml.find(" ")
               if blanko>0: mmeml=mmeml[0:blanko]
         red=redovi[2]
         mmtema=""
         if red[0:5]=="Tema:":
            mmtema=red[6:]
            red=redovi[3]
         mmidpor=0 
         if red[0]=="(":
            zagr=red.find(")")
            if zagr == -1:
               log("Los heder #1")
               continue
            else:
               idpor=red[1:zagr]
               tacka=idpor.find(".")
               if tacka<0:
                   idpor1=idpor
                   idpor2="0"
               else:
                   idpor1=idpor[0:tacka]
                   idpor2=idpor[tacka+1:]
               idpor1=vodecenule(idpor1,5)
               idpor2=vodecenule(idpor2,5)
               idpor=idpor2 + idpor1
               mmdat=red[zagr+6:zagr+22]
               mmdat=extrdate(mmdat)
         else:
            log("Los header #2")
            continue
         trebaparse=False
         ignore=False
         if grupa:
             idpor=gprefiks+"-"+idpor
             trebaparse=True
         else:
             if not (len(mmeml)==12 and mmeml[-4:]==".EML"):
                 trebaparse=True
         if len(mmeml)>0:
            if not fexists(p_temp+mmeml):
                log("Nedostaje fajl: "+mmeml)
                mmeml=""
            elif trebaparse==False and grupa==False:
            #   prekopiraj EML fajl na destinaciju uz novo ime
                filecopy(p_temp+mmeml, p_target+idpor+"."+curpad[0:8]+".EML")
         mbody=True
         celaporuka=""
   file1.close()

